*
* COPYDISK: Disk to Disk direct copy utility
*
* Copyright 1983-2005 Dave Dunfield
* All rights reserved.
*
OSRAM	EQU	$0000
OSEND	EQU	$C2FF
OSUTIL	EQU	$B700

MAXBUFR	EQU	(OSEND-BUFFER)/512 	;# SECTORS TO BUFFER
*
	ORG	OSRAM		PROGRAM LOCATION
* TEST FOR HELP REQUEST
CPYDSK	CMPA	#'?'		HELP?
	BNE	QUAL		NO
	SWI
	FCB	25		OUTPUT MESSAGE
	FCC	'Use: COPYDISK[/PROMPT/QUIET] <source drive> <dest drive>'
	FCB	00
	RTS
* TEST FOR QUALIFIERS
QUAL	LDA	,Y		GET CHAR FROM LINE
	CMPA	#'/'		QUALIFIER?
	BNE	MAIN		NO, START UP PGM
	LDX	#QTABLE		PT TO TABLE
	SWI
	FCB	18		LOOKUP QUALIFIER
	CMPB	#NUMQ		IN RANGE?
	BHS	QERR		NO, INVALID
	LDX	#QFLAGS		PT TO FLAGS
	CLR	B,X		SET THE FLAG
	BRA	QUAL		GET NEXT
* QUALIFIER WAS INVALID, REPORT
QERR	SWI
	FCB	24		MESSAGE
	FCC	/Invalid qualifier: '/
	FCB	00
	LDA	,Y+		GET CHAR
QSHOW	SWI
	FCB	33		DISPLAY IT
	SWI
	FCB	5		LOOK FOR TERMINATOR
	BEQ	QEND		EXIT
	CMPA	#'/'		ALSO TERMINATOR
	BNE	QSHOW		SHOW EM ALL
QEND	SWI
	FCB	25		MESSAGE
	FCC	/'/		CLOSING QUITE
	FCB	00
	LDA	#1		BAD OPERAND RC
ABORT	SWI
	FCB	0		RETURN TO OS
* DISK TO DISK COPY PROGRAM
MAIN	SWI
	FCB	16		GET SOURCE
	BNE	ABORT		ERROR
	STA	>SOURCE		SAVE
	SWI
	FCB	81		GET SIZE
	PSHS	A,B		SAVE
	SWI
	FCB	16		GET DEST
	BNE	ABORT		ERROR
	STA	>DEST		SAVE
	SWI
	FCB	81		GET SIZE
	CMPD	,S++		MATCH?
	BEQ	MAIN1		YES
	SWI
	FCB	25
	FCC	'Incompatable drive sizes'
	FCB	00
	LDA	#100
	RTS
* COPY DISK
MAIN1	STD	>DSIZE		SAVE DRIVE SIZE
	LDA	>PROMPT
	BNE	CPY		DON'T PROMPT
	SWI
	FCB	88		PURGE
	SWI
	FCB	24		OUTPUT MESSAGE
	FCC	'Insert disks, press <return>:'
	FCB	00
	SWI
	FCB	3		GET LINE
CPY	LDA	>SOURCE		GET SOURCE DRIVE
	SWI
	FCB	76		SELECT
	CMPA	>DEST		SAME DRIVE?
	BNE	CPY1		NO
	SWI
	FCB	24		MESSAGE
	FCB	$0D		CARRIAGE RETURN
	FCC	'Insert source disk, press <return>:'
	FCB	00
	SWI
	FCB	3		WAIT
* READ A BUFFER INTO MEMORY
CPY1	LDA	>QUIET
	BEQ	QUI1
	SWI
	FCB	25
	FCB	$0D		CARRIAGE RETURN
	FCC	'Reading'
	FCB	00
QUI1	LDX	#BUFFER		PT TO RAM AREA
	LDY	#MAXBUFR		ZERO COUNT
RDB1	LDD	>RSECT		GET SECTOR ID
	CMPD	>DSIZE		OVER?
	BHS	RDEND		YES, EXIT
	TST	>QUIET
	BEQ	QUI2		NO SECTOR COUNT
	LDA	#$0D		GET CR
	SWI
	FCB	33		OUTPUT
	LDD	>RSECT		RESTORE ADDRESS
	SWI
	FCB	26
QUI2	SWI
	FCB	92		READ SECTOR
	LBNE	EXIT		ERROR
	LEAX	512,X		ADVANCE
	ADDD	#1		ADVANCE NUM
	STD	>RSECT		RESAVE
	LEAY	-1,Y		ADVANCE COUNT
	BNE	RDB1		NO, ITS OK
RDEND	LDA	>DEST		GET DEST
	SWI
	FCB	76		SELECT
	CMPA	>SOURCE		SAME AS SOURCE?
	BNE	CPY2		NO
	SWI
	FCB	24		MESSAGE
	FCB	$0D		CARRIAGE RETURN
	FCC	'Insert destination disk, press <return>:'
	FCB	00
	SWI
	FCB	3		WAIT FOR RETURN
* WRITE A BUFFER FROM MEMORY
CPY2	LDA	>QUIET
	BEQ	QUI3
	SWI
	FCB	25
	FCB	$0D		CARRIAGE RETURN
	FCC	'Writing'
	FCB	00
QUI3	LDX	#BUFFER		PT TO RAM AREA
	LDY	#MAXBUFR	ZERO COUNT
WRB1	LDD	>WSECT		GET SECTOR ID
	CMPD	>DSIZE		OVER?
	BHS	WREND		IF SO, QUIT
	TST	>QUIET
	BEQ	QUI4
	LDA	#$0D		CARRIAGE RETURN
	SWI
	FCB	33
	LDD	>WSECT		RESTORE SECTOR ID
	SWI
	FCB	26
QUI4	SWI
	FCB	93		WRITE SECTOR
	BNE	EXIT		ERROR
	LEAX	512,X		NEXT
	ADDD	#1		ADVANCE
	STD	>WSECT		RESAVE
	LEAY	-1,Y		ADVANCE COUNT
	BNE	WRB1		MORE
WREND	LDD	>WSECT		RESTORE SECTOR
	CMPD	>DSIZE		OVER LIMIT
	LBLO	CPY		DO IT AGAIN SAM
	LDA	>QUIET
	BEQ	QUI5
	SWI
	FCB	22		OUTPUT LFCR
QUI5	CLRA
EXIT	SWI
	FCB	0
* QUALIFIER TEXT TABLE
QTABLE	FCB	$82		1 CHAR MATCH
	FCC	'/QUIET'
	FCB	$82
	FCC	'/PROMPT'
	FCB	$80		END OF TABLE
NUMQ	EQU	2		# OF QUALIFIERS
QFLAGS	EQU	*		QUALIFIER FLAG TABLE
QUIET	FCB	$FF		DON'T DISPLAY READ/WRITES
PROMPT	FCB	$FF		PROMPT FOR DISK SHANGE
* MISC VARAIBLES
RSECT	FDB	0		CURRENT READ SECTOR
WSECT	FDB	0		CURRENT WRITE SECTOR
SOURCE	RMB	1		SOURCE DRIVE
DEST	RMB	1		DESTINATION DRIVE
DSIZE	RMB	2		DRIVE SIZE
*
BUFFER	EQU	*
